/******************************************************************************************
*                                BITSTRING.H                                              *
* La classe bitstring permette di inserire dati in una stringa un bit alla                *
* volta oppure un byte alla volta, lo stesso avviene per la lettura dei                   *
* dati dalla stringa.                                                                     *    
* In realta' usa una byte come buffer nel quale scrive i bit tramite l'operatore          *
* di shift bit a bit. Tra i membri privati quindi troviamo tale byte_buffer               *
* poi num_byte che mi dice quanti byte sono stati scritti sulla stringa, e num_bit        *
* che invece mi dice al momento quanti bit sono stati bufferizzati (nota bene, tali       *
* bit verranno effettivamente trascritti sulla stringa solo quando il buffer si           *
* riempira'. Una volta implementate le due funzioni di leggi_bit e scrivi_bit e'          *
* abbastanza facile implementare le due funzioni leggi_byte e scrivi_byte, che difatto    *
* usano in modo iterativo le prime due. Infine c'e' la funzione svuota_buffer che deve    *
* essere utilizzata quando si ha la certezza che non e' piu' necessario scrivere sulla    *
* stringa, tale funzione accoda al buffer dei zeri fino a riempirlo e quindi lo scarica   *
* sulla stringa, la variabile bit_offset conterra' il numero di zeri finali che sono      *
* stati aggiunti.                                                                         *
* N.B. l'intero DIM contiene la dimensione con la quale viene allocata la stringa,        *
* il numero di byte effettivamente scritti lo si puo' ottenere con la funzione            *
* bitstring::lunghezza_byte().                                                            *  
* NOTA vista l'assenza di un costruttore di copia, quando si passa una bitstring come     *         
* parametro di una funzione  necessario passarla per riferimento (oppure passare un      *
* puntatore), anche se la bitstring sar usata solo in lettura.                           *   
*                                                             Antonio Caputo               *
******************************************************************************************/


typedef unsigned char BYTE;	// definizione del tipo BYTE
typedef unsigned char BIT;	// definizione del tipo BIT

class bitstring
{
  BYTE byte_buffer;		// byte d'appoggio in cui vengono scritti i bit
  int num_bit;			// numero di bit che sono contenuti in byte_buffer
  int num_byte;			// numero di byte scritti sulla stringa
  int bit_offset;		// bit di riempimento scritti nell'ultimo byte dall'operazione svuota_buffer
public:
  int DIM;			// dimensione della stringa
  unsigned char *stringa;
    bitstring (int);		// costruttore, il parametro sara' la lunghezza della stringa (DIM)
    bitstring (unsigned char *, int);	// costruttore, copia la stringa passata.
   ~bitstring ();		// distruttore 
  void scrivi_bit (BIT);	// accoda un bit alla stringa
  BIT leggi_bit (int);		// legge il bit nella posizione indicata        
  void scrivi_byte (BYTE);	// accoda un byte alla stringa
  BYTE leggi_byte (int);	// legge un byte dalla stringa
  void svuota_buffer ();	// scrive il byte_buffer sulla stringa
  int lunghezza_bit ();		// lunghezza in bit
  int lunghezza_byte ();	// lunghezza in byte
};
