/*************************************************************
*                 BITSTRING.CPP                              *
* In questo file  contenuta l'implementazione della classe  *
* bitstring.						     * 
*                                    Antonio Caputo          *
*************************************************************/


#include <iostream>
#include <cstring>
#include "bitstring.h"


// COSTRUTTORE, il parametro da passargli indica la lunghezza
// della stringa
bitstring::bitstring (int dim)
{
  stringa = new (unsigned char[dim]);
  byte_buffer = 0;
  num_bit = 0;
  num_byte = 0;
  bit_offset = 0;
  DIM = dim;
}

bitstring::bitstring (unsigned char *str, int len)
{
  stringa = new (unsigned char[len]);
  //   strcpy ((char *)stringa,(char *)str);
  memcpy (stringa, str, len);
  byte_buffer = 0;
  num_bit = len * 8;
  num_byte = len;
  bit_offset = 0;
  DIM = len;
}

// DISTRUTTORE, dealloca la stringa
bitstring::~bitstring ()
{
  delete[]stringa;
}

// SCRIVI_BIT, scrive il bit fornitogli come parametro accodandolo
// alla stringa, in realta' il bit viene inserito nel byte_buffer.
// Se si riscontra che il byte_buffer e' pieno (num_bit=8) allora
// si svuota il buffer copiandolo sulla stringa
void
bitstring::scrivi_bit (BIT bit)
{
  if (num_byte < DIM)
    {
      byte_buffer = (byte_buffer << 1) | bit;
      num_bit++;
      if (num_bit == 8)
	{
	  stringa[num_byte] = byte_buffer;
	  num_byte++;
	  num_bit = 0;
	}
    }
  else
    cout << "Errore, non  possibile scrivere, stringa piena" << endl;
}

// LEGGI_BIT, legge il bit che si trova nella posizione pos (intesa
// come numero di bit),partendo da 0, quindi ad esempio leggi_bit(13)
// restituisce il sesto bit  del secondo byte.
// Se si cerca di leggere un bit non ancora scritto si ottiene un
// errore e viene restituito cmq zero.
BIT
bitstring::leggi_bit (int pos)
{
  int
    byte_pos = pos / 8;
  int
    bit_pos = pos % 8;
  BYTE
    temp = 0;
  if (byte_pos < num_byte)
    {
      temp = stringa[byte_pos];
    }
  else
    {
      cout << "ERRORE : Stai cercando di leggere un bit che non e' stato ancora scritto" << endl;
    }
  return ((temp >> (7 - bit_pos)) & 1);
}


// SCRIVI_BYTE, scrive un intero byte in coda alla stringa. Se il byte
// buffer e' vuoto (num_bit=0) scrive direttamente sulla stringa,
// altrimenti usa la funzione SCRIVI_BIT per scaricare il byte, chiaramente
// in questo caso solo una parte del byte da scrivere andra' subito sulla
// stringa la restante parte rimarra' momentaneamente nel buffer.
void
bitstring::scrivi_byte (BYTE byte)
{
  if (num_byte < DIM)
    {
      if (num_bit == 0)
	{
	  stringa[num_byte] = byte;
	  num_byte++;
	}
      else
	{
	  unsigned char
	    tmp;
	  BIT
	    bit;
	  for (int j = 7; j >= 0; j--)
	    {
	      tmp = byte;
	      bit = ((tmp >> j) & 1);
	      scrivi_bit (bit);
	    }
	}
    }
  else
    cout << "Errore : non puoi pi scrivere, stringa piena" << endl;
}


// LEGGI_BYTE, questa funzione legge un intero byte a partire dal bit indicato
// dal parametro pos (ancora una volta inteso come numero di bit). Se possibile
// accede direttamente alla stringa altrimenti legge i bit uno ad uno e li copia
// nella variabile byte che poi sara' il valore restituito
BYTE
bitstring::leggi_byte (int pos)
{
  int
    byte_pos = pos / 8;
  int
    bit_pos = pos % 8;
  if ((bit_pos) == 0)
    {
      return (BYTE) stringa[byte_pos];
    }
  else
    {
      BYTE
	byte;
      for (int i = 7; i >= 0; i--)
	{
	  byte = ((byte << 1) | leggi_bit (pos + i));
	}
      return byte;
    }
}

// SVUOTA_BUFFER, questa funzione va usata per svuotare il byte buffer una volta
// che si abbia la certezza di non dover piu' scrivere sulla stringa, alla fine
// calcola il valore bit_offset, rappresentante il numero di bit fasulli che si e'
// dovuto inserire per riempire il byte.
void
bitstring::svuota_buffer ()
{
  if (num_bit != 0)
    {
      bit_offset = 8 - num_bit;
      for (int i = 0; i < bit_offset; i++)
	{
	  scrivi_bit (0);
	}
    }
  else
    bit_offset = 0;
}

// LUNGHEZZA_BIT, restituisce la lunghezza, in bit, della stringa
int
bitstring::lunghezza_bit ()
{
  return ((num_byte * 8) - bit_offset);
}

// LUNGHEZZA_BYTE, restituisce la lunghezza, in byte, della stringa, n.b. l'ultimo
// byte contiene un numero di bi di riempimento pari a bit_offset
int
bitstring::lunghezza_byte ()
{
  return num_byte;
}
