/**********************************************
*                Classe UDPSocket             *
* Con questa classe e' possibile scambiare    *
* messaggi tra un client ed un server tramite *
* una socket UDP che puo' funzionare anche in *
* modalita' connessa.                         *
*	          	     Antonio Caputo   *
**********************************************/

#include <iostream>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string>
using namespace std;

enum mode {  connected , unconnected  }; //modalit di apertura della socket

// Classe generica dalla quale eridito quelle client e server.
// Implementa le funzioni comuni ad entrambi i lati della socket
class UDPSocket
{
   protected:
      int            sock_ds;
      sockaddr_in    server_address;
   public:
      UDPSocket();
      ~UDPSocket();
      int    sendto(string message,string dest, int port);
      string recvfrom(string& dest, int &port, int len=-1);
      int    sock_descriptor() {return sock_ds;}
};


// Tale classe introduce dei membri per memorizzare le informazioni
// del server a cui e' eventualmente connesso, se il client non e'
// connesso tali campi non sono inizializzati.
// Quindi la chiamata delle funzioni server_name e server-port va 
// fatta solo se la socket e' connessa.
class UDPClient :public UDPSocket
{
      hostent *      host;
      string 	     hostname;
      mode  	     c_mode;
      int            port_number;
   public:
      UDPClient():UDPSocket(),c_mode(unconnected){  };
      void    connect(string dest,int port);
      int     send(string message);
      string  recv(int len=-1);
      mode    connect_mode() {return c_mode;}
      string  server_name() {return hostname;}
      int     server_port() {return port_number;}
};

// Questa classe aggiunge ben poco a quella base, viene semplicemente
// esteso il costruttore al fine di rendere possibile la bind.
class UDPServer :public UDPSocket
{
   public:
      UDPServer (int port);
};
