/********************************************
* Implementazione della classe UDPSocket    *
********************************************/

#include "UDPSocket.h"
//#include <cstring>

//Costruttore base, crea semplicemente il descrittore della socket
UDPSocket :: UDPSocket ()
{
   sock_ds=socket(PF_INET,SOCK_DGRAM,IPPROTO_UDP);
}

//Distruttore, chiude la socket
UDPSocket :: ~UDPSocket()
{
   shutdown(sock_ds,2);
}

// Questa funzione permette di spedire il messaggio message,
// all'host di nome dest sul porto port
int UDPSocket :: sendto(string message,string dest,int port)
{
   in_addr addr;
   sockaddr_in remote_address;
   hostent *   remote_host;
   remote_address.sin_family = AF_INET;
   remote_address.sin_port = htons (port);
   memset(&(remote_address.sin_zero),'\0',8);
   if (!(remote_host = gethostbyname(dest.c_str())))
   {
      cout<<"ERRORE : Impossibile risolvere il nome del server"<<endl;
      return 0;
   }
   addr =*((in_addr *)remote_host->h_addr);
   remote_address.sin_addr.s_addr=addr.s_addr;
   if (addr.s_addr == 0 ) // l'indirizzo e' stato passato nella forma numerica puntata
      remote_address.sin_addr.s_addr = inet_addr (dest.c_str());

   if(::sendto(sock_ds,message.c_str(),message.length(),0,(sockaddr *)&remote_address,sizeof (remote_address))==-1)
   {
      cout<<"ERRORE : Non  stato possibile completare la trasmissione"<<endl;
      return 0;
   }
   else
      return message.length();
}


// Riceve un messaggio e lo restituisce, e poi memorizza in dest
// e port le informazioni dell'host che ha mandato il messaggio
string UDPSocket :: recvfrom(string& dest,int &port,int len)
{
   if (len==-1)
      len=1000;
   hostent * remote_host;
   sockaddr_in remote_address;
   char * temp = new (char [len]);
   int flen=sizeof(remote_address);
   if(::recvfrom(sock_ds,temp,len,0,(sockaddr *)&remote_address,(socklen_t *)&flen)==-1)
   {
      cout<<"ERRORE : Non  stato possibile completare la ricezione"<<endl;
      return 0;
   }
   else
   {
      port = ntohs (remote_address.sin_port);
      dest = inet_ntoa(remote_address.sin_addr);
      return temp;
   }

}

// Effettua la connessione del client al server specificato dai parametri
void UDPClient :: connect(string dest,int port)
{
   c_mode = connected;
   port_number = port;
   server_address.sin_family = AF_INET;
   server_address.sin_port = htons (port);
   memset(&(server_address.sin_zero),'0',8);
   hostname = dest;
   in_addr addr;
   if (!(host=gethostbyname(dest.c_str())))
   {
      cout<<"ERRORE : Impossibile risolvere il nome del server"<<endl;
      exit(-1);
   }
   addr = *((in_addr *)host->h_addr);
   server_address.sin_addr.s_addr = addr.s_addr;
   if (addr.s_addr == 0 ) // e' stata usata la forma numerica puntata
      server_address.sin_addr.s_addr = inet_addr (dest.c_str());

   if (::connect(sock_ds,(sockaddr *) &server_address,sizeof (server_address))==-1)
   {
      cout<<"ERRORE : Connessione all'host "<<hostname<<" fallita"<<endl;
      c_mode =unconnected;
   }
}

// Manda un messaggio al server a cui e' connesso il client, va utilizzata
// solo se lo stato e' connected
int UDPClient :: send(string message)
{
   if (c_mode==connected)
   {
      if(::send(sock_ds,message.c_str(),message.length(),0)==-1)
      {
	 cout<<"ERRORE : Non  stato possibile completare la trasmissione"<<endl;
	 return 0;
      }
      else
	 return message.length();
   }
   else
   {
      cout<<"ERRORE : Socket non connessa"<<endl;
      return 0;
   }
}

// Riceve un messaggio dal server a cui e' connesso il client, va utilizzata
// solo se lo stato e' connected
string UDPClient :: recv(int len)
{
   if (len==-1)
      len=1000;     // se non specificato setta il buffer di lettura a 1000 bytes
   char * temp=new (char[len]);
   if (c_mode==connected)
   {
      if(::recv(sock_ds,temp,len,0)==-1)
      {
	 cout<<"ERRORE : Non  stato possibile completare la ricezione"<<endl;
	 return 0;
      }
      else
	 return temp;

   }
   else
   {
      cout<<"ERRORE : Socket non connessa"<<endl;
      return 0;
   }
}


// Costruttore della classe UDPServer, richiama quello della classe ereditata
// ed in piu' completa l'associazione della socket con una bind
UDPServer :: UDPServer (int port): UDPSocket()
{
   server_address.sin_family = AF_INET;
   server_address.sin_port = htons (port);
   memset(&(server_address.sin_zero),'0',8);
   server_address.sin_addr.s_addr = htonl (INADDR_ANY);
   if (bind(sock_ds,(sockaddr *) &server_address,sizeof(server_address))==-1)
   {
      cout<<"ERRORE : Impossibile completare il bind della socket sul porto prescelto"<<endl;
      exit(-1);
   }
}


