/***************************************************
*                   TCPSOCKET.H                    *
* In questo file c' la definizione della classi   *
* TCPSocket, TCPClient, TCPServer.                 * 
* La prima definita  TCPSocket, in realt  una   *
* classe generica che non  utilizzabile da sola,  *
* introduce quelle parti che sono comuni sia nella *
* costruzione di un client che di un server.       *
* Le classi TCPClient e TCPServer ereditano questa *
* classe ed aggiungono/ridefiniscono i metodi ti-  *
* ci per un client o per un server                 *
                                Antonio Caputo     *
***************************************************/


#include <iostream>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string>
using namespace std;


// Classe generica dalla quale eredito quelle client e server.
// Implementa le funzioni comuni ad entrambi i lati della socket
class TCPSocket
{
protected:
  int sock_ds;			//descrittore della socket
  sockaddr_in server_address;
  hostent *host;
  string hostname;		//nome dell'host remoto
  int port_number;		//numero di porto remoto
public:
    TCPSocket ();
   ~TCPSocket ();
  int send (string message, int sock);	//manda il messaggio sulla socket sock
  string recv (int sock, int len = -1);	//riceve un messaggio sulla socket sock
  string remote_name ()
  {
    return hostname;
  }				//ritorna il nome dell'host remoto
  int remote_port ()
  {
    return port_number;
  }				//ritorna il numero di porto remoto
  int sock_descriptor ()
  {
    return sock_ds;
  }				//ritorna sock_ds
};

//Classe TCPClient, specializza il costruttore al fine di realizzare
//un client, in pratica completa la connessione al server indicato
//dai parametri dest e port
class TCPClient:public TCPSocket
{
public:
  TCPClient (string dest, int port);
  int send (string message)
  {
    return TCPSocket::send (message, sock_ds);
  }
  string recv (int len = -1) { return TCPSocket::recv (sock_ds, len);
  }
};

//Classe TCPServer, specializza il costruttore per realizzare un
//server, quindi completa le fasi di bind e listen, sono state
//poi aggiunte le funzioni accept, per accettare connessioni dai
//client, ed hangup, per chiuderle.
class TCPServer:public TCPSocket
{
  int sec_sock_ds;		//sock sulla quale si fa l'accept
public:
    TCPServer (int port);
  int accept ();
  string recv (int len = -1) { return TCPSocket::recv (sec_sock_ds, len);
  }
  int send (string message)
  {
    return TCPSocket::send (message, sec_sock_ds);
  }
  void hangup ();
  int sec_sock_descriptor ()
  {
    return sec_sock_ds;
  }
};
