/******************************************************
*                    TCPSOCKET.CPP                    *
* In questo file c' l'implementazione delle classi   *
* TCPSocket, TCPClient e TCPServer                    *
*                                   Antonio Caputo    *
******************************************************/


#include "TCPSocket.h"
#include <unistd.h>

//Costruttore base, crea semplicemente il descrittore della socket
TCPSocket::TCPSocket ()
{
  sock_ds = socket (PF_INET, SOCK_STREAM, IPPROTO_TCP);
}

//Distruttore, chiude la socket
TCPSocket::~TCPSocket ()
{
  shutdown (sock_ds, 2);
}

//manda un messaggio su sock
int
TCPSocket::send (string message, int sock)
{
  if (sock != -1)
    {
      if (::send (sock, message.c_str (), message.size(), 0) == -1)
	{
	  cout << "ERRORE : Non  stato possibile completare la trasmissione" << endl;
	  return 0;
	}
      else
	return message.length ();
    }
  else
    return 0;
}

// Riceve un messaggio da sock
string TCPSocket::recv (int sock, int len)
{
  if (len == -1)
    len = 1000;			// se non specificato setta il buffer di lettura a 1000 bytes
  char *
    temp = new (char[len]);
  if (::recv (sock, temp, len, 0) == -1)
    {
      cout << "ERRORE : Non  stato possibile completare la ricezione" << endl;
      return 0;
    }
  else
  {
    string mom(temp);
    return mom;
  }
    
}


// Costruttore del client. Effettua la connessione del client al server
//specificato dai parametri
TCPClient::TCPClient (string dest, int port):TCPSocket ()
{
  port_number = port;
  server_address.sin_family = AF_INET;
  server_address.sin_port = htons (port);
  memset (&(server_address.sin_zero), '0', 8);
  hostname = dest;
  in_addr addr;
  if (!(host = gethostbyname (dest.c_str ())))
    {
      cout << "ERRORE : Impossibile risolvere il nome del server" << endl;
      exit (-1);
    }
  addr = *((in_addr *) host->h_addr);
  server_address.sin_addr.s_addr = addr.s_addr;
  if (addr.s_addr == 0)		// e' stata usata la forma numerica puntata
    server_address.sin_addr.s_addr = inet_addr (dest.c_str ());

  if (::connect (sock_ds, (sockaddr *) & server_address, sizeof (server_address)) == -1)
    {
      cout << "ERRORE : Connessione all'host " << hostname << " fallita" << endl;
    }
}



// Costruttore della classe TCPServer, richiama quello della classe ereditata
// ed in piu' completa l'associazione della socket con una bind e si mette in
// listen
TCPServer::TCPServer (int port):
TCPSocket (), sec_sock_ds (-1)
{
  server_address.sin_family = AF_INET;
  server_address.sin_port = htons (port);
  memset (&(server_address.sin_zero), '0', 8);
  server_address.sin_addr.s_addr = htonl (INADDR_ANY);
  if (bind (sock_ds, (sockaddr *) & server_address, sizeof (server_address)) == -1)
    {
      cout << "ERRORE : Impossibile completare il bind della socket sul porto prescelto" << endl;
      exit (-1);
    }
  listen (sock_ds, 5);
}

//effettua l'accept per una richiesta di connessione, da questo momento sock_ds manterra' il
//descrittore per la socket usata per la connessione, la socket di ascolto del server invece
//viene mantenuta in sec_sock_ds
int
TCPServer::accept ()
{
  sockaddr_in remote_address;
  int
    flen = sizeof (remote_address);
  if ((sec_sock_ds =::accept (sock_ds, (sockaddr *) & remote_address, (socklen_t *) & flen)) == -1)
    {
      cout << "ERRORE : Impossibile accettare la richiesta";
      return (-1);
    }
  else
    {
      port_number = ntohs (remote_address.sin_port);
      hostname = inet_ntoa (remote_address.sin_addr);
      return 0;
    }
}

//chiude la connessione con un client, ripristina il valore di sock_ds
void
TCPServer::hangup ()
{
  if (sec_sock_ds != -1)
    {
      close (sec_sock_ds);
      sec_sock_ds = -1;
    }
}
